# script.module.streamlink

## Download

It can be installed from `repository.back-to`

- https://github.com/back-to/repo
- https://github.com/back-to/repo/raw/master/repository.back-to/repository.back-to-5.0.0.zip

## Support

- LiveProxy
  https://github.com/back-to/liveproxy

- Generic Plugin
  https://github.com/back-to/generic

- Default Plugins
  https://github.com/streamlink/streamlink

# script.module.pycryptodome

Only **Kodi Leia** has `script.module.pycryptodome` **prepacked**.

If you want to use this plugin on **Krypton**,

you will have to install [pycryptodome](https://github.com/Legrandin/pycryptodome#pycryptodome) on **your system**
and create a **dummy** `script.module.pycryptodome` plugin.

If you are on Linux, you might need to install it even with **Kodi Leia**

```
pip install pycryptodome
```

# Guide

## How to use this libary with Kodi?

**Kodi Leia** has pycryptodomex **prepacked**,
but streamlink only supports pycryptodome.

You will have to rename the **Cryptodome** package into **Crypto**

Add this to your **main** class

```py
import sys
try:
    import Cryptodome
    sys.modules['Crypto'] = Cryptodome
except ImportError:
    # Cryptodome is not installed,
    # but Crypto might be installed
    pass
```

After this everything from the Streamlink API should work.

https://streamlink.github.io/api_guide.html

## How to rebuild this Kodi-Addon?

It's not automated yet ...

- remove the `resources/lib/streamlink` folder
- create a `bdist` or `wheel` of streamlink
- from the `bdist` unpack the `streamlink` folder to the empty `resources/lib/streamlink`
- run `python replace.py`
- update `addon.xml`
